(async () => {
    const statusEl = document.getElementById('status')
    const networkEl = document.getElementById('network')
    const accountEl = document.getElementById('account')

    try {
        const data = await chrome.storage.local.get(['chainId', 'accounts'])
        statusEl.textContent = '실행 중 ✅'
        networkEl.textContent = data.chainId || '0x67'
        if (data.accounts && data.accounts.length > 0) {
            const addr = data.accounts[0]
            accountEl.textContent = addr.slice(0, 6) + '...' + addr.slice(-4)
        } else {
            accountEl.textContent = '연결된 계정 없음'
        }
    } catch (e) {
        statusEl.textContent = '오류'
    }
})()
